uniform vec3 u_TargetColor;
uniform sampler2D u_Tex0;
uniform sampler2D u_Tex1;
varying vec2 v_TexCoord;

float getLuminance(vec3 color) {
    return dot(color, vec3(0.2126, 0.7152, 0.0722));
}

void main() {
    vec4 texColor0 = texture2D(u_Tex0, v_TexCoord);
    float originalLuminance = getLuminance(texColor0.rgb);
    vec3 targetColorScaled = u_TargetColor * originalLuminance;
    vec4 texColor1 = texture2D(u_Tex1, v_TexCoord);
    vec3 mixedColor = texColor0.rgb * targetColorScaled + texColor1.rgb * (1.0 - originalLuminance);
    vec3 intensifiedRed = mix(mixedColor, u_TargetColor, pow(originalLuminance, 4.0));
    vec3 finalColor = clamp(intensifiedRed, 0.0, 1.0);
    vec3 brightColor = mix(finalColor, vec3(1.0), pow(originalLuminance, 5.0));
    gl_FragColor = vec4(brightColor, texColor0.a);
}
