uniform float u_TextureSize;
uniform float u_Time;
uniform float u_colorR;
uniform float u_colorG;
uniform float u_colorB;
uniform sampler2D u_Tex0;
varying vec2 v_TexCoord;

void main()
{
	float offset = 1.0 / u_TextureSize;
    vec4 col = texture2D(u_Tex0, v_TexCoord);
    if (col.a > 0.5)
        gl_FragColor = col;
    else {
        float a = 0.0;
        for (float x = -2.0; x <= 2.0; x += 1.0) {
            for (float y = -2.0; y <= 2.0; y += 1.0) {
                vec2 offsetCoord = vec2(v_TexCoord.x + x * offset, v_TexCoord.y + y * offset);
                a += texture2D(u_Tex0, offsetCoord).a;
            }
        }
        a /= 9.0;
        if (col.a < 1.0 && a > 0.0) {
            float pulse = (cos(u_Time * 6.0) + 1.0) / 2.0;
            float alpha = pulse * 0.5 + 0.5;
            vec3 color = vec3(u_colorR, u_colorG, u_colorB);
            gl_FragColor = vec4(color, a * alpha);
        }
        else {
            gl_FragColor = col;
        }
    }
}