uniform float u_Time;
uniform sampler2D u_Tex0;
varying vec2 v_TexCoord;

float rand(vec2 co) {
    return fract(sin(dot(co, vec2(12.9898, 78.233))) * 43758.5453);
}

float darkPlasma(vec2 uv, float t) {
    // Powolne pulsowanie
    float pulse = 1.0 + 0.05 * sin(t * 1.0);
    uv *= pulse;

    float value = 0.0;
    value += sin(uv.x * 10.0 + t * 0.2);
    value += sin(uv.y * 15.0 + t * 0.15);
    value += sin((uv.x + uv.y) * 8.0 + t * 0.1);
    return (value / 3.0) * 0.5 + 0.5;
}

vec3 chromaticAberration(sampler2D tex, vec2 uv, float offset) {
    float r = texture2D(tex, uv + vec2(offset, 0.0)).r;
    float g = texture2D(tex, uv).g;
    float b = texture2D(tex, uv - vec2(offset, 0.0)).b;
    return vec3(r, g, b);
}

void main()
{
    vec4 baseColor = texture2D(u_Tex0, v_TexCoord);

    float gray = dot(baseColor.rgb, vec3(0.3, 0.59, 0.11));
    vec3 desaturated = mix(baseColor.rgb, vec3(gray), 0.6);

    float darkness = darkPlasma(v_TexCoord * 2.0, u_Time);
    float darknessFactor = smoothstep(0.3, 0.9, darkness);

    vec3 brokenTint = vec3(0.4, 0.05, 0.6);

    vec3 chromaColor = chromaticAberration(u_Tex0, v_TexCoord, 0.002);

    vec3 finalColor = mix(desaturated, brokenTint, 0.3 + 0.2 * darknessFactor);
    finalColor = mix(finalColor, chromaColor, 0.2);
    finalColor *= (1.0 - 0.4 * darknessFactor);

    gl_FragColor = vec4(finalColor, baseColor.a);
}
